﻿var NUM_COLUMNS = 4;
var g_RowCount = 0;
var g_OffSet = 0;

var card_index;
var port_index;
var colWidth = new Array("80px","100px","140px","100px");

function AddRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		var row = table.insertRow(g_RowCount + 1);

		for(var j = 0; j < NUM_COLUMNS; j++)
		{
			var cell = row.insertCell(j);
		}
		
		g_RowCount++;
	}
}

function UpdateRowNum(tableId, dataLen)
{
	g_OffSet = g_RowCount;
	AddRows(tableId, (dataLen - 1));
}

function UpdateRowData(table, rowID, rowData)
{
	var row = rowID + g_OffSet;
	
	for(var i = 0; i < NUM_COLUMNS; i++)
	{
		var cell = table.rows[row].cells[i];
		cell.style.width = colWidth[i];
		
		if(i == 2)
		{
			cell.innerHTML = "";
			var el = document.createElement("img");
			el.width = "86";
			el.height = "13";
			el.align = "bottom";
			el.alt = "Output Bandwidth display";
			el.src = '../images/pb_' + rowData[i - 1] + '.jpg';
			cell.appendChild(el);
		}
		else
		{
			if(i == 0)
			{
				port_index = row;
				cell.innerHTML = card_index + "/" + port_index;
			}
			else
			{
				cell.innerHTML = rowData[i - 1];
			}
		}
	}
}

function UpdateTableData(tableId, outpResp)
{
	var dataLen = outpResp.length;
	var MeasRow = new Array(NUM_COLUMNS);
	var table = document.getElementById(tableId);
	for(var i = 0;i < (dataLen - 1); i++)
	{
		MeasRow = outpResp[i];
		var rowData = MeasRow.split(",");
		UpdateRowData(table, (i + 1), rowData);
	}
}

function PaintMeasTable(MeasTable)
{
	var dataLen = MeasTable.length;//the end is row value, then dataLen is n+1
	UpdateRowNum("MeasOutpTable",dataLen);
	UpdateTableData("MeasOutpTable",MeasTable);
	return true;
}

var rf_port;
var init_row = true;
function GetMeasureOutpData()
{
	var xmlhttp = false;
	xmlhttp = getHTTPObject();

	if(init_row)
	{
		rf_port = card_index + "/" + "1";
	}
	
	var params = "type=12&cmd=1&rf_port=" + rf_port;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var Response = xmlhttp.responseText;
			var outpResp = Response.slice(7, -8).split("&");
			var outpLen = outpResp.length;
			PaintMeasTable(outpResp);

			init_row = false;
			
			if(outpResp[outpLen - 1].indexOf("rf_port") != -1)
			{
				var cur_row_string = outpResp[outpLen - 1].split(",");
				rf_port = cur_row_string[1];
			}

			if(outpResp[outpLen - 1] == "end")
			{
				init_row = true;
				return true;
			}
			setTimeout("GetMeasureOutpData()", 5);
		}
	}
	xmlhttp.send(params);
}

/***** functions called on load of page *****/
window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);  
	
	GetMeasureOutpData();
}

